/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 8 BIT UNIVERSAL SHIFT  REGISTERS 
TRUTHTABLE     : 

--------------------------------------------------------------------------------
MODE  CLR_ S1 S0 G1_ G2_ CLK   SR  SL  A/QA ...................... H/QH  QAO QHO  
--------------------------------------------------------------------------------
       L   X  L   L  L    X    X    X    L   L   L   L   L   L   L   L   L   L
CLEAR  L   L  X   L  L    X    X    X    L   L   L   L   L   L   L   L   L   L
       L   H  H   X  X    X    X    X    L   L   L   L   L   L   L   L   L   L
--------------------------------------------------------------------------------
HOLD   H   L  L   L  L    X    X    X    Q0  QB  QC  QD  QE  QF  QG  Q7  Q0  Q7
       H   X  X   L  L    L    X    X    Q0  QB  QC  QD  QE  QF  QG  Q7  Q0  Q7
--------------------------------------------------------------------------------
                           _   
SHIFT  H   L  H   L  L   _/    X    H    H   Q0  QB  QC  QD  QE  QF  QG  H   QG
RIGHT                      _   
       H   L  H   L  L   _/    X    L    L   Q0  QB  QC  QD  QE  QF  QG  L   QG
--------------------------------------------------------------------------------
                           _   
SHIFT  H   H  L   L  L   _/    H    X    QB  QC  QD  QE  QF  QG  Q7  H   QB  H
LEFT                       _   
       H   H  L   L  L   _/    L    X    QB  QC  QD  QE  QF  QG  Q7  L   QB  L
--------------------------------------------------------------------------------
                           _   
LOAD   H   H  H   X  X   _/    X    X    A   B   C   D   E   F    G  H   A  H
--------------------------------------------------------------------------------

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a299 (s0, g1n, g2n, gqg, eqe, cqc, aqa, qat, clrn, sr, clk, bqb, dqd, fqf, hqh, qht, sl, s1);
	parameter size =1;
	input
		clrn,
		g1n,
		g2n,
		s0,
		s1,
		clk,
		sr,
		sl;
	output
		qat,
		qht;
	inout
		aqa,
		bqb,
		cqc,
		dqd,
		eqe,
		fqf,
		gqg,
		hqh;
    reg
        NOTIFY_REG;
    not
	N1 (s0_, s0);
    not
	N2 (s1_, s1);
    and
	A1 (en1, s0, s1, clrn);
    and
	A2 (en2, s0_, s1, clrn);
    and
	A3 (en3, s0, s1_, clrn);
    and
	M299_inst_A1 (m299_inst_wa1, s0, s1);
    and
	M299_inst_A2 (m299_inst_wa2, sr, m299_inst_wi7, m299_inst_wi1);
    and
	M299_inst_A3 (m299_inst_wa3, m299_inst_wi2, m299_inst_wi6, m299_inst_wdndl2_5);
    and
	M299_inst_A4 (m299_inst_wa4, m299_inst_wi2, m299_inst_wi7, aqa);
    and
	M299_inst_A5 (m299_inst_wa5, m299_inst_wi1, m299_inst_wi6, m299_inst_qaint);
    and
	M299_inst_A6 (m299_inst_wa6, m299_inst_qaint, m299_inst_wi7, m299_inst_wi1);
    and
	M299_inst_A7 (m299_inst_wa7, m299_inst_wi2, m299_inst_wi6, m299_inst_wdndl3_5);
    and
	M299_inst_A8 (m299_inst_wa8, m299_inst_wi2, m299_inst_wi7, bqb);
    and
	M299_inst_A9 (m299_inst_wa9, m299_inst_wi1, m299_inst_wi6, m299_inst_wdndl2_5);
    and
	M299_inst_A10 (m299_inst_wa10, m299_inst_wdndl2_5, m299_inst_wi7, m299_inst_wi1);
    and
	M299_inst_A11 (m299_inst_wa11, m299_inst_wi2, m299_inst_wi6, m299_inst_wdndl4_5);
    and
	M299_inst_A12 (m299_inst_wa12, m299_inst_wi2, m299_inst_wi7, cqc);
    and
	M299_inst_A13 (m299_inst_wa13, m299_inst_wi1, m299_inst_wi6, m299_inst_wdndl3_5);
    and
	M299_inst_A14 (m299_inst_wa14, m299_inst_wdndl3_5, m299_inst_wi7, m299_inst_wi1);
    and
	M299_inst_A15 (m299_inst_wa15, m299_inst_wi2, m299_inst_wi6, m299_inst_wdndl5_5);
    and
	M299_inst_A16 (m299_inst_wa16, m299_inst_wi2, m299_inst_wi7, dqd);
    and
	M299_inst_A17 (m299_inst_wa17, m299_inst_wi1, m299_inst_wi6, m299_inst_wdndl4_5);
    and
	M299_inst_A18 (m299_inst_wa18, m299_inst_wdndl4_5, m299_inst_wi7, m299_inst_wi1);
    and
	M299_inst_A19 (m299_inst_wa19, m299_inst_wi2, m299_inst_wi6, m299_inst_wdndl6_5);
    and
	M299_inst_A20 (m299_inst_wa20, m299_inst_wi2, m299_inst_wi7, eqe);
    and
	M299_inst_A21 (m299_inst_wa21, m299_inst_wi1, m299_inst_wi6, m299_inst_wdndl5_5);
    and
	M299_inst_A22 (m299_inst_wa22, m299_inst_wdndl5_5, m299_inst_wi7, m299_inst_wi1);
    and
	M299_inst_A23 (m299_inst_wa23, m299_inst_wi2, m299_inst_wi6, m299_inst_wdndl7_5);
    and
	M299_inst_A24 (m299_inst_wa24, m299_inst_wi2, m299_inst_wi7, fqf);
    and
	M299_inst_A25 (m299_inst_wa25, m299_inst_wi1, m299_inst_wi6, m299_inst_wdndl6_5);
    and
	M299_inst_A26 (m299_inst_wa26, m299_inst_wdndl6_5, m299_inst_wi7, m299_inst_wi1);
    and
	M299_inst_A27 (m299_inst_wa27, m299_inst_wi2, m299_inst_wi6, m299_inst_qhint);
    and
	M299_inst_A28 (m299_inst_wa28, m299_inst_wi2, m299_inst_wi7, gqg);
    and
	M299_inst_A29 (m299_inst_wa29, m299_inst_wi1, m299_inst_wi6, m299_inst_wdndl7_5);
    and
	M299_inst_A30 (m299_inst_wa30, m299_inst_wdndl7_5, m299_inst_wi7, m299_inst_wi1);
    and
	M299_inst_A31 (m299_inst_wa31, m299_inst_wi2, m299_inst_wi6, sl);
    and
	M299_inst_A32 (m299_inst_wa32, m299_inst_wi2, m299_inst_wi7, hqh);
    and
	M299_inst_A33 (m299_inst_wa33, m299_inst_wi1, m299_inst_wi6, m299_inst_qhint);
    not
	M299_inst_I1 (m299_inst_wi1, s1);
    not
	M299_inst_I2 (m299_inst_wi2, m299_inst_wi1);
    not
	M299_inst_I6 (m299_inst_wi6, s0);
    not
	M299_inst_I7 (m299_inst_wi7, m299_inst_wi6);
    or
	M299_inst_O1 (m299_inst_wo1, m299_inst_wa2, m299_inst_wa3, m299_inst_wa4, m299_inst_wa5);
    or
	M299_inst_O2 (m299_inst_wo2, m299_inst_wa6, m299_inst_wa7, m299_inst_wa8, m299_inst_wa9);
    or
	M299_inst_O3 (m299_inst_wo3, m299_inst_wa10, m299_inst_wa11, m299_inst_wa12, m299_inst_wa13);
    or
	M299_inst_O4 (m299_inst_wo4, m299_inst_wa14, m299_inst_wa15, m299_inst_wa16, m299_inst_wa17);
    or
	M299_inst_O5 (m299_inst_wo5, m299_inst_wa18, m299_inst_wa19, m299_inst_wa20, m299_inst_wa21);
    or
	M299_inst_O6 (m299_inst_wo6, m299_inst_wa22, m299_inst_wa23, m299_inst_wa24, m299_inst_wa25);
    or
	M299_inst_O7 (m299_inst_wo7, m299_inst_wa26, m299_inst_wa27, m299_inst_wa28, m299_inst_wa29);
    or
	M299_inst_O8 (m299_inst_wo8, m299_inst_wa30, m299_inst_wa31, m299_inst_wa32, m299_inst_wa33);
    nor
	M299_inst_N1 (m299_inst_wn1, m299_inst_wa1, g1n, g2n);
    bufif1  
	M299_inst_BUF1 (aqa, m299_inst_qaint, m299_inst_wn1);
    bufif1  
	M299_inst_BUF2 (bqb, m299_inst_wdndl2_5, m299_inst_wn1);
    bufif1  
	M299_inst_BUF3 (cqc, m299_inst_wdndl3_5, m299_inst_wn1);
    bufif1  
	M299_inst_BUF4 (dqd, m299_inst_wdndl4_5, m299_inst_wn1);
    bufif1  
	M299_inst_BUF5 (eqe, m299_inst_wdndl5_5, m299_inst_wn1);
    bufif1  
	M299_inst_BUF6 (fqf, m299_inst_wdndl6_5, m299_inst_wn1);
    bufif1  
	M299_inst_BUF7 (gqg, m299_inst_wdndl7_5, m299_inst_wn1);
    bufif1  
	M299_inst_BUF8 (hqh, m299_inst_qhint, m299_inst_wn1);
    buf  
	  (qat, m299_inst_qaint);
    buf  
	  (qht, m299_inst_qhint);
    U_FD_P_RB_NO  
	M299_inst_DNDL1_inst1 (m299_inst_qaint, m299_inst_wo1, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M299_inst_DNDL2_inst1 (m299_inst_wdndl2_5, m299_inst_wo2, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M299_inst_DNDL3_inst1 (m299_inst_wdndl3_5, m299_inst_wo3, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M299_inst_DNDL4_inst1 (m299_inst_wdndl4_5, m299_inst_wo4, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M299_inst_DNDL5_inst1 (m299_inst_wdndl5_5, m299_inst_wo5, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M299_inst_DNDL6_inst1 (m299_inst_wdndl6_5, m299_inst_wo6, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M299_inst_DNDL7_inst1 (m299_inst_wdndl7_5, m299_inst_wo7, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M299_inst_DNDL8_inst1 (m299_inst_qhint, m299_inst_wo8, clk, clrn, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
